#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/metadata.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition_gateway.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/txn_id.h>
#include <maps/wikimap/mapspro/services/mrc/libs/juggler/include/juggler.h>

#include <pqxx/pqxx>

#include <chrono>
#include <string>

namespace maps::mrc::eye {

juggler::Message checkRunTime(
        MetadataManager& metadata,
        std::chrono::hours warnTime,
        std::chrono::hours errorTime);


class QueueChecker {
public:
    virtual ~QueueChecker() {};

    static std::unique_ptr<QueueChecker> byMetadataName(
        const std::string& gatewayName,
        const std::string& name);

    static std::unique_ptr<QueueChecker> byTxnIdKey(
        const std::string& gatewayName,
        const std::string& key);

    virtual juggler::Message checkQueueSize(
        pqxx::transaction_base& txn,
        size_t warnSize,
        size_t errorSize) = 0;

    virtual size_t getQueueSize(pqxx::transaction_base& txn) = 0;
};

using QueueCheckerPtr = std::unique_ptr<QueueChecker>;

} // namespace maps::mrc::eye
