#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition.h>

#include <pqxx/pqxx>

namespace maps::mrc::eye {

struct TxnIdDetectionId {
    /// max txnId among all inputs for this detection
    db::TId txnId;
    db::TId detectionId;
};

struct TxnIdDetectionGroupId {
    db::TId detectionGroupId;
    std::vector<TxnIdDetectionId> txnDetectionIds = {};
};

struct Batch {
    db::TId beginTxnId;
    db::TId endTxnId;
    std::vector<TxnIdDetectionGroupId> detectionGroupIds;
};

Batch getNewBatch(
    pqxx::transaction_base& txn,
    db::TId beginTxnId,
    size_t limit,
    const db::eye::DetectionTypes& detectionTypes);


db::TIds extractDetectionGroupIds(const std::vector<TxnIdDetectionGroupId>& txnDetectionGroupIds);
db::TIds extractDetectionIds(const std::vector<TxnIdDetectionId>& txnDetectionIds);
db::TIds extractDetectionIds(const std::vector<struct TxnIdDetectionGroupId>& txnDetectionGroupIds);

} // namespace maps::mrc::eye
