#include <maps/wikimap/mapspro/services/mrc/eye/lib/object_manager/impl/clusters.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/object_manager/include/object_manager.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/object_manager/impl/object.h>

namespace maps::mrc::eye {

void removeUntouchedClusters(
    std::vector<db::TIdSet>* clusters,
    const db::TIdSet& detectionIds)
{
    clusters->erase(
        std::remove_if(clusters->begin(), clusters->end(),
            [&](const auto& cluster) {
                return !intersected(detectionIds, cluster);
            }
        ),
        clusters->end()
    );
}

} // namespace maps::mrc::eye
