#include <maps/wikimap/mapspro/services/mrc/eye/lib/object_manager/impl/common.h>

namespace maps::mrc::eye {

db::TIdSet selectBiggestDetectionIds(
    const DetectionStore& store,
    const db::TIdSet& detectionIds,
    size_t limit)
{
    if (detectionIds.size() <= limit) {
        return detectionIds;
    }

    // <detectionId, площадь прямоугольника>
    std::vector<std::pair<db::TId, double>> detectionSizes;
    for (db::TId detectionId : detectionIds) {
        detectionSizes.emplace_back(
            detectionId,
            store.detectionById(detectionId).box().area()
        );
    }

    std::partial_sort(
        detectionSizes.begin(), detectionSizes.begin() + limit, detectionSizes.end(),
        [&](const std::pair<db::TId, double>& lhs, const std::pair<db::TId, double>& rhs) {
            return lhs.second > rhs.second;
        }
    );

    db::TIdSet result;
    for (size_t i = 0; i < limit; i++) {
        result.insert(detectionSizes[i].first);
    }

    return result;
}

db::TIds intersect(const db::TIdSet& ids1, const db::TIdSet& ids2)
{
    db::TIds result;

    std::set_intersection(
        ids1.begin(),
        ids1.end(),
        ids2.begin(),
        ids2.end(),
        std::back_inserter(result));

    return result;
}


} // namespace maps::mrc::eye
