#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/id.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/store.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/object_manager/impl/passage.h>

#include <vector>

namespace maps::mrc::eye {

// Выбирает не более limit наибольших детекций среди
// детекций с id из detectionIds.
// Детекция считается больше другой детекции, если
// площадь ее прямоугольника на изображении больше.
// Площадь прямоугольника = (x_max - x_min) * (y_max - y_min)
// Если детекций меньше, чем limit, то возвращается все
// множество detectionIds
db::TIdSet selectBiggestDetectionIds(
    const DetectionStore& store,
    const db::TIdSet& detectionIds,
    size_t limit);


db::TIds intersect(const db::TIdSet& ids1, const db::TIdSet& ids2);
} // namespace maps::mrc::eye
