#pragma once
#include "batch.h"

#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/store.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/object_manager/impl/store.h>

namespace maps::mrc::eye {

// Сохраняет изменения полученные от ObjectManager'а в базу
// 1. Обновляет связи между детекциями
// 2. Обновляет объекты
// 3. Обновляет позиции объектов. Если у кого-то объекта,
//    который уже есть в базе изменяется состав связанных
//    с ним детекций, то его позиция меняется, чтобы соответствовать
//    новым связанным детекциям
//
// * detectionIdsByPrimaryId - набор связанных детекций, которые должны
//                             сформировать новые объекты и связи в базе.
//                             detectionIds должен включать в себя primaryId,
//                             т.е. все detectionIds как минимум не пустые.
db::eye::Objects saveObjects(
    pqxx::transaction_base& txn,
    const db::IdTo<db::TIdSet>& detectionIdsByPrimaryId,
    const db::IdTo<chrono::TimePoint>& detectionIdToDisappearenceDate = {});

db::IdTo<db::TIds> loadGroupIdToDetectionIdsMap(
    pqxx::transaction_base& txn, const db::TIds& detectionGroupIds);

// удаляем id групп детекций, которые уже были обработаны,
// все их детекции должны удовлетворять одному из следующих условий:
// 1) наибольший txnId соответствующих записей в eye.primary_detection_relation больше
//     максимального txnId соответствующих записей входных таблиц:
//     - eye.frame_location
//     - eye.detection{, _group, _relation}
//     - eye.verified_detection_pair_match (reads updates)
// 2) детекция не удалена, уже присутствует в каком-нибудь кластере, и
//    содержимое eye.verified_detection_pair_match согласуется с текущей конфигурацией кластеров
void removeProcessedDetectionGroupIds(
    pqxx::transaction_base& txn,
    std::vector<TxnIdDetectionGroupId>* detectionGroupIdsPtr);

} // namespace maps::mrc::eye
