#include<maps/wikimap/mapspro/services/mrc/eye/lib/object_manager/impl/location.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition.h>

#include <maps/libs/geolib/include/conversion.h>
#include <maps/libs/geolib/include/distance.h>

#include <maps/libs/common/include/exception.h>

namespace maps::mrc::eye {

Location makeObjectLocation(const DetectionStore& store, const db::TIdSet& detectionIds)
{
    REQUIRE(not detectionIds.empty(), "Empty detection list!");
    const auto [groups, detections, frames, locations, devices] = store.slice(detectionIds);

    const auto& reference = groups.front();
    for (const auto& group: groups) {
        REQUIRE(
            reference.type() == group.type(),
            "Different types " << reference.id() << ":" << reference.type()
                << " and " << group.id() << ":" << group.type()
        );
    }

    const auto objectType = toObjectType(reference.type());
    switch (objectType) {
        case db::eye::ObjectType::HouseNumber:
            return findHouseNumberLocation(frames, locations, detections);
        case db::eye::ObjectType::Sign:
            return findSignLocation(devices, frames, locations, detections);
        case db::eye::ObjectType::TrafficLight:
            return findTrafficLightLocation(devices, frames, locations, detections);
        case db::eye::ObjectType::RoadMarking:
            return findRoadMarkingLocation(locations);

        default:
            throw RuntimeError() << "Inavalid object " << objectType;
    }
}

bool areDifferent(
        const db::eye::ObjectLocation& oldLocation,
        const Location& newLocation,
        double positionToleranceMeters,
        geolib3::Degrees rotationTolerance)
{
    const double positionTolerance = geolib3::toMercatorUnits(
        positionToleranceMeters,
        oldLocation.mercatorPos()
    );

    return geolib3::distance(oldLocation.mercatorPos(), newLocation.mercatorPosition) > positionTolerance
        or absDiffInDegrees(oldLocation.rotation(), newLocation.rotation) > rotationTolerance;
}

} // namespace maps::mrc::eye
