#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/object_manager/impl/passage.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/object_manager/impl/store.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/id.h>

namespace maps::mrc::eye {

// Параметры по которым проводится проверка на возможность
// объединения двух объектов. Считается, что два объекта
// могут представлять один и тот же физический объект,
// если объекты имеют одинаковый тип и аттрибуты,
// а также выполняются два условия:
//   distance(objectLocation1.pos, objectLocation2.pos) < distanceMeters,
//   angleDiff(objectLocation1.rotation, objectLocation2.rotation) < angleDiff,
//
// где objectLocation1, objectLocation2 позиции object'ов соответственно.
struct MergeCandidatesParams {
    double distanceMeters;
    geolib3::Degrees angleEpsilon;
};

// Генерирует все возможные пары объектов, которые могут
// соответствовать одному и тому же физическому объекту.
// Объекты могут соответствовать одному объекту, если они
// удовлетворяют всем условиям, которые задаются в params.
// В результирующем векторе хранятся пары идентификторов
// объектов из проездов ({primaryId, passageId})
std::vector<std::pair<ObjectPassageIndx, ObjectPassageIndx>>
generateMergeCandidates(
    const std::vector<ObjectsInPassage>& objectsByPassages,
    const MergeCandidatesParams& params);

} // namespace maps::mrc::eye
