#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/store.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/object.h>

namespace maps::mrc::eye {

// Выбирает главную детекцию в наборе детекций.
// Отдает предпочтение детекциям, имеющим наибольшую относительную
// площадь, а также детекциям, которые уже являются главными детекциями
// у существующих объектов.
db::TId choosePrimaryId(
    const DetectionStore& store,
    const db::TIdSet& detectionIds,
    std::function<bool(db::TId)> isPrimaryDetectionId = [](db::TId) { return false; });

db::eye::Object makeHouseNumber(const DetectionStore& store, db::TId primaryId);

db::eye::Object makeTrafficLight(const DetectionStore& store, db::TId primaryId);

db::eye::Object makeSign(const DetectionStore& store, db::TId primaryId);

db::eye::Object makeRoadMarking(const DetectionStore& store, db::TId primaryId);

db::eye::Object makeObject(const DetectionStore& store, db::TId primaryId);

} // namespace maps::mrc::eye

