#pragma once

#include "merge_candidates.h"

#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/store_utils.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/match_candidates.h>

#include <maps/libs/geolib/include/units.h>

#include <chrono>

namespace maps::mrc::eye {

// Maximum distance from object at witch it can be detected
static constexpr double OBJECT_VISIBILITY_DISTANCE_METERS = 50.;

// Параметры, по которым детекции разбиваются на проезды
static constexpr SplitPassageParams SPLIT_PASSAGE_PARAMS{
    .metersEpsilon = OBJECT_VISIBILITY_DISTANCE_METERS,
    .secondsEpsilon = std::chrono::seconds(15 * 60)
};

static constexpr std::chrono::seconds PASSAGE_TIME_PAD = std::chrono::seconds(3 * 60);

static constexpr MatchCandidatesParams MATCH_CANDIDATE_PARAMS{
    .distanceMeters = OBJECT_VISIBILITY_DISTANCE_METERS,
    .angleEpsilon = geolib3::Degrees(90.0)
};

static constexpr MergeCandidatesParams MERGE_CANDIDATES_PARAMS{
    .distanceMeters = 30.0,
    .angleEpsilon = geolib3::Degrees(45.0)
};

// Params used for searching frames confirming objects disappearence
static constexpr MatchCandidatesParams DISAPPEARANCE_CANDIDATE_PARAMS{
    .distanceMeters = 15,
    .angleEpsilon = geolib3::Degrees(30.0)
};

} // namespace maps::mrc::eye
