#pragma once

#include "store.h"

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/object.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/id.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/match.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/cluster.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/txn.h>

#include <pqxx/pqxx>
#include <unordered_map>

namespace maps::mrc::eye {

struct ObjectsInPassage {
    // Объекты, созданные по детекциям из одного проезда
    db::IdTo<db::eye::Object> objectByPrimaryId;
    db::IdTo<Location> locationByPrimaryId;
    // Связь главных детекций объектов с другими детекциями.
    // В связанных детекциях содержится в том числе и сама главная детекция
    db::IdTo<db::TIdSet> detectionIdsByPrimaryId;
};

// Обрабатываем набор детекций по проездам:
std::vector<ObjectsInPassage> makeObjectsByPassages(
    const DetectionStore& store,
    const FrameMatcher& frameMatcher,
    const DetectionMatcher& detectionMatcher,
    const DetectionClusterizer& clusterizer,
    const std::vector<db::TIdSet>& passages);


// Объекты создаются внутри проездов. За один раз могут быть обработаны
// несколько проездов, т.е. имеется массив из групп объектов в проездах.
// Внутри проезда каждый объект имеет уникальную главную детекцию (primaryId)
// Следовательно, чтобы однозначно определить объект, необходимо указать
// главную детекцию объекта и порядковый номер проезда.
// first (db::TId) - id главной детекции у объекта
// second (size_t) - порядковый номер проезда, в котором был получен объект
using ObjectPassageIndx = std::pair<db::TId, size_t>;
using ObjectPassageIndxPair = std::pair<ObjectPassageIndx, ObjectPassageIndx>;

struct MatchedObjects {
    ObjectPassageIndx objectPassageIndx1;
    ObjectPassageIndx objectPassageIndx2;
    float relevance;
    std::optional<MatchedFrameDetection::Verdict> verdict;
};


ObjectStore
loadExistingObjectsToMatch(
    pqxx::transaction_base& txn,
    DetectionStore& detectionStore,
    chrono::TimePoint actualAt
);

ObjectsInPassage makeFakeObjectsInPassage(
    const DetectionStore& detectionStore,
    const ObjectStore& objectStore);

std::vector<MatchedObjects> matchObjectsByPassages(
    const DetectionStore& detectionStore,
    const FrameMatcher& frameMatcher,
    const DetectionMatcher& detectionMatcher,
    const std::vector<ObjectsInPassage>& objectsInPassages
);

class VerificationRequestsIndex;

// Merges objects matched in passages into new clusters
// @return primaryDetectionId -> [detectionId] map
db::IdTo<db::TIdSet> mergeObjectsByPassages(
    const std::vector<MatchedObjects>& sortedObjectsMatches,
    const DetectionStore& detectionStore,
    const ObjectStore& objectStore,
    const std::vector<ObjectsInPassage>& objectsByPassages,
    const FrameMatcher& frameMatcher,
    const DetectionMatcher& detectionMatcher,
    std::function<bool(const db::TIdSet&, const db::TIdSet&)> areAllowedToMerge);

} // namespace maps::mrc::eye
