#pragma once

#include "../include/verification_policy.h"
#include "../include/object_manager.h"
#include "pqxx/transaction_base.hxx"

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/privacy/include/geo_id_provider.h>

#include <maps/libs/pgpool/include/pgpool3.h>

#include <pqxx/pqxx>

#include <map>

namespace maps::mrc::eye {

/// Holds verification results for detection pairs
/// guarantees commutative property i.e.
/// VerificationResult(id1, id2) always equals VerificationResult(id2, id1)
class VerificationRequestsIndex
{
public:
    VerificationRequestsIndex() = default;

    void set(db::TId id1, db::TId id2, std::optional<bool> value);

    bool contains(db::TId id1, db::TId id2) const;

    // throws std::out_of_range if does not contain this pair
    const std::optional<bool>& get(db::TId id1, db::TId id2) const;

    std::set<db::TId> referencedDetections() const;

    std::vector<std::pair<db::TId, db::TId>> referencedPairs() const;

private:
    std::map<std::pair<db::TId, db::TId>, std::optional<bool>> detectionPairToResult_;

};

VerificationRequestsIndex loadVerifiedMatches(
    pqxx::transaction_base& txn,
    const db::TIds& detectionIds);


struct MatchedObjects;

/// Applies @param verificationRules to given @param clusters,
/// creates necessary verification requests for matching detections
/// and checking detection missingness on frame
void createVerificationRequests(
    pqxx::transaction_base& txn,
    const VerificationRules& verificationRules,
    const privacy::GeoIdProvider& geoidProvider,
    const DetectionStore& detectionStore,
    const VerificationRequestsIndex& existingRequests,
    const std::vector<MatchedObjects>& matchedObjects,
    const db::IdTo<db::TIdSet>& clusters,
    const db::eye::Objects& objects,
    const db::IdTo<db::TIds>& missingDetectionIdToFrameIds
);

} // namespace maps::mrc::eye
