#pragma once

#include "verification_policy.h"

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/config.h>

#include <maps/wikimap/mapspro/services/mrc/libs/privacy/include/geo_id_provider.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/match.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/cluster.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/visibility_predictor.h>

namespace maps::mrc::eye {

struct ObjectManagerConfig {
    MrcWorkerConfig mrc;
    std::shared_ptr<FrameMatcher> frameMatcher;
    std::shared_ptr<DetectionMatcher> detectionMatcher;
    std::shared_ptr<DetectionClusterizer> clusterizer;
    std::shared_ptr<ClusterVisibilityPredictor> visibilityPredictor;
    db::eye::DetectionTypes detectionTypes;
    privacy::GeoIdProviderPtr geoIdProvider;
    VerificationRules verificationRules;
    // Если rework = false, то из обрабатываемого батча
    // исключаются детекции, которые удовлетворяют одному
    // из следующих условий:
    //  1) Неудаленная детекция является главной детекцией
    //     неудаленного объекта
    //  2) Неудаленная детекция связана неудаленной связью
    //     с неудаленной детекцией неудаленного объекта
    bool rework;
};

bool isValid(const ObjectManagerConfig& config);

} // namespace maps::mrc::eye
