#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/base_worker.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/object_manager/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/match.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/cluster.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/visibility_predictor.h>

#include <pqxx/pqxx>

namespace maps::mrc::eye {

struct TxnIdDetectionGroupId;

// This process is responsible for tracking lifetime of objects that were
// seen on frames. It reads data from tables:
// - eye.frame_location
// - eye.detection{, _group, _relation}
// - eye.verified_detection_pair_match (reads updates)
// - eye.verified_detection_missing_on_frame (reads updates)
// and writes data into tables:
// - eye.object{, _location, _relation}
// - eye.primary_detection_relation
//  - eye.verified_detection_pair_match (creates new records)
class ObjectManager: public BaseMrcWorkerWithConfig<ObjectManagerConfig, common::LockId::EyeObjectManager>
{
public:
    static constexpr auto POSITION_TOLERANCE_METERS = double(1);
    static constexpr auto ROTATION_TOLERANCE = geolib3::Degrees(10);

    ObjectManager(const ObjectManagerConfig& config);

    virtual ~ObjectManager() = default;

    void processBatch(const db::TIds& detectionGroupIds) override;

    bool processBatchInLoopMode(size_t size) override;

protected:
    std::shared_ptr<FrameMatcher> frameMatcher_;
    std::shared_ptr<DetectionMatcher> detectionMatcher_;
    std::shared_ptr<DetectionClusterizer> clusterizer_;
    std::shared_ptr<ClusterVisibilityPredictor> visibilityPredictor_;

private:

    // Does all the actual work without commiting to the database
    pgpool3::TransactionHandle processDetectionGroups(
        const std::vector<struct TxnIdDetectionGroupId>& detectionGroupIds);

};

} // namespace maps::mrc::eye
