#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/object.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/object_attrs.h>

#include <functional>
#include <vector>

namespace maps::mrc::eye {

using ObjectPredicate = std::function<bool(const db::eye::Object&)>;


struct VerificationAction {
    /// Check that the detections of the same cluster really correspond to
    /// the same object
    bool verifyObjectDetections = false;
    /// Check that nearly standing objects are really different
    bool verifyObjectDuplication = false;
    /// Verify that new photos confirm that the object does not exists
    bool verifyObjectMissingness = false;
};

struct VerificationRule {
    db::TId geoId;
    db::eye::ObjectType objectType;
    ObjectPredicate objectPredicate;

    VerificationAction verificationAction;
};

using VerificationRules = std::vector<VerificationRule>;

VerificationRules loadVerificationRules();

VerificationAction merge(const VerificationAction& one, const VerificationAction& other);

} // namespace maps::mrc::eye
