#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/id.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/object_manager/impl/clusters.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/location/include/rotation.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/unit_test/include/frame.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition_gateway.h>

#include <library/cpp/testing/gtest/gtest.h>
#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace maps::mrc::eye::tests {


TEST(remove_untouched_clusters_should, basic_test)
{
    db::TIdSet detectionIds{0u, 1u, 2u, 3u};
    std::vector<db::TIdSet> clusters{
        {0u, 1u},
        {2u, 4u},
        {5u},
        {6u, 3u},
        {7u, 8u},
    };

    removeUntouchedClusters(&clusters, detectionIds);

    std::vector<db::TIdSet> expected{
        {0u, 1u},
        {2u, 4u},
        {6u, 3u},
    };

    EXPECT_THAT(clusters, ::testing::UnorderedElementsAreArray(expected));
}


} // namespace maps::mrc::eye::tests
