#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/id.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/object_manager/impl/merge_candidates.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/location/include/rotation.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/unit_test/include/frame.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace maps::mrc::eye::tests {


TEST(merge_candidates_should, base_test)
{
    ObjectsInPassage passage1;
    passage1.objectByPrimaryId = {
        {
            db::TId(5),
            {
                db::TId(5),
                db::eye::SignAttrs{
                    .type = traffic_signs::TrafficSign::ProhibitoryMaxSpeed10,
                    .temporary = false
                }
            }
        },
        {
            db::TId(0),
            {
                db::TId(0),
                db::eye::SignAttrs{
                    .type = traffic_signs::TrafficSign::ProhibitoryMaxSpeed10,
                    .temporary = false
                }
            },
        }
    };
    passage1.locationByPrimaryId = {
        {
            db::TId(5),
            {
                geolib3::Point2{0, 0},
                toRotation(geolib3::Heading(90), identical)
            }
        },
        {
            db::TId(0),
            {
                geolib3::Point2{20, 0},
                toRotation(geolib3::Heading(90), identical)
            }
        }
    };

    ObjectsInPassage passage2;
    passage2.objectByPrimaryId = {
        {
            db::TId(0),
            {
                db::TId(0),
                db::eye::SignAttrs{
                    .type = traffic_signs::TrafficSign::ProhibitoryMaxSpeed10,
                    .temporary = false
                }
            }
        },
        {
            db::TId(1),
            {
                db::TId(1),
                db::eye::SignAttrs{
                    .type = traffic_signs::TrafficSign::ProhibitoryMaxSpeed10,
                    .temporary = false
                }
            }
        },
        {
            db::TId(2),
            {
                db::TId(2),
                db::eye::SignAttrs{
                    .type = traffic_signs::TrafficSign::ProhibitoryMaxSpeed10,
                    .temporary = false
                }
            }
        },
        {
            db::TId(3),
            {
                db::TId(3),
                db::eye::SignAttrs{
                    .type = traffic_signs::TrafficSign::ProhibitoryMaxSpeed10,
                    .temporary = true
                }
            }
        },
        {
            db::TId(4),
            {
                db::TId(4),
                db::eye::TrafficLightAttrs{}
            },
        }
    };
    passage2.locationByPrimaryId = {
        {
            db::TId(0),
            {
                geolib3::Point2{20, 0},
                toRotation(geolib3::Heading(90), identical)
            }
        },
        {
            db::TId(1),
            {
                geolib3::Point2{0, 0},
                toRotation(geolib3::Heading(90), identical)
            }
        },
        {
            db::TId(2),
            {
                geolib3::Point2{0, 0},
                toRotation(geolib3::Heading(200), identical)
            }
        },
        {
            db::TId(3),
            {
                geolib3::Point2{0, 0},
                toRotation(geolib3::Heading(90), identical)
            }
        },
        {
            db::TId(4),
            {
                geolib3::Point2{0, 0},
                toRotation(geolib3::Heading(90), identical)
            }
        },
    };

    std::vector<ObjectsInPassage> objectsByPassages;
    objectsByPassages.push_back(std::move(passage1));
    objectsByPassages.push_back(std::move(passage2));

    MergeCandidatesParams params{
        .distanceMeters = 10,
        .angleEpsilon = geolib3::Degrees(90)
    };

    auto objectPassageIndxPairs
        = generateMergeCandidates(objectsByPassages, params);

    ASSERT_EQ(objectPassageIndxPairs.size(), 2u);

    {
        const auto& [objectPassageIndx1, objectPassageIndx2] = objectPassageIndxPairs[0];

        const auto& [primaryId1, passageIndx1] = objectPassageIndx1;
        const auto& [primaryId2, passageIndx2] = objectPassageIndx2;
        EXPECT_EQ(primaryId1, 0u);
        EXPECT_EQ(passageIndx1, 0u);

        EXPECT_EQ(primaryId2, 0u);
        EXPECT_EQ(passageIndx2, 1u);
    }

    {
        const auto& [objectPassageIndx1, objectPassageIndx2] = objectPassageIndxPairs[1];

        const auto& [primaryId1, passageIndx1] = objectPassageIndx1;
        const auto& [primaryId2, passageIndx2] = objectPassageIndx2;
        EXPECT_EQ(primaryId1, 5u);
        EXPECT_EQ(passageIndx1, 0u);

        EXPECT_EQ(primaryId2, 1u);
        EXPECT_EQ(passageIndx2, 1u);
    }
}

} // namespace maps::mrc::eye::tests
