#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/match.h>
#include <maps/wikimap/mapspro/services/mrc/libs/privacy/include/geo_id_provider.h>

#include <library/cpp/testing/gtest/gtest.h>

namespace maps::mrc::eye::tests {


struct MockGeoIdProvider: public privacy::GeoIdProvider {
    MOCK_METHOD(db::TIds, load, (const geolib3::BoundingBox&), (const, override));
    MOCK_METHOD(geolib3::MultiPolygon2, geomById, (db::TId geoId), (const, override));
    MOCK_METHOD(db::TIds, load, (const geolib3::Point2& geoPoint), (const, override));
};

inline auto makeMockGeoIdProvider() {
    return std::make_shared<MockGeoIdProvider>();
}


class MockFrameMatcher : public FrameMatcher {
public:
    MockFrameMatcher() = default;

    MatchedFramesPairs makeMatches(
        const DetectionStore& /*store*/,
        const std::vector<std::pair<db::TId, db::TId>>& /*frameIdPairs*/) const override
    {
        return {};
    }
};


class MockDetectionMatcher : public DetectionMatcher {
public:

    MockDetectionMatcher(std::vector<db::TIdSet> detectionClusters)
        : detectionClusters_(std::move(detectionClusters))
    {}

    MatchedFrameDetections makeMatches(
        const DetectionStore& store,
        const DetectionIdPairSet& detectionPairs,
        const FrameMatcher*) const override
    {
        MatchedFrameDetections result;
        for (const auto& pair : detectionPairs) {
            for (const auto& cluster : detectionClusters_) {
                if (cluster.count(pair.first)) {
                    if (cluster.count(pair.second)) {
                        result.push_back(
                            MatchedFrameDetection{
                                {.frameId = store.frameId(pair.first), .detectionId = pair.first},
                                {.frameId = store.frameId(pair.second), .detectionId = pair.second},
                                1.
                            }
                        );
                    } else {
                        break;
                    }
                } else if (cluster.count(pair.second)) {
                    break;
                }
            }
        }
        return result;
    }
private:

    std::vector<db::TIdSet> detectionClusters_;
};

class MockDetectionMatcherMatchAll : public DetectionMatcher {
public:


    MatchedFrameDetections makeMatches(
        const DetectionStore& store,
        const DetectionIdPairSet& detectionPairs,
        const FrameMatcher*) const override
    {
        MatchedFrameDetections result;
        for (const auto& pair : detectionPairs) {
            result.push_back(
                MatchedFrameDetection{
                    {.frameId = store.frameId(pair.first), .detectionId = pair.first},
                    {.frameId = store.frameId(pair.second), .detectionId = pair.second},
                    1.
                }
            );
        }
        return result;
    }
};


} // namespace maps::mrc::eye::tests
