#include <maps/wikimap/mapspro/services/mrc/eye/lib/playground/include/config.h>

#include <maps/wikimap/mapspro/services/mrc/libs/yt/include/common.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/superpoints_match.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/position_matcher.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/position_clusterizer.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/visibility_predictor.h>

#include <random>
#include <string>

namespace maps::mrc::eye {

namespace {
constexpr auto YT_POOL_TYPE = maps::mrc::yt::PoolType::AdHoc;

std::string randomHash()
{
    std::random_device device;
    std::default_random_engine engine(device());
    std::uniform_int_distribution<char> uniform('a', 'z');

    std::string hash;
    for (size_t i = 0; i < 4; ++i) {
        if (i > 0) {
            hash.push_back('-');
        }

        for (size_t j = 0; j < 4; ++j) {
            hash.push_back(uniform(engine));
        }
    }

    return hash;
}

} // namespace

PlaygroundConfig::PlaygroundConfig(): hash(randomHash()) {}

bool isValid(const PlaygroundConfig& config) {
    return config.mrcPool && config.mds && config.yt && config.frameLoader;
}

ImportMrcConfig makeImportMrcConfig(const PlaygroundConfig& config)
{
    ImportMrcConfig workerConfig;
    workerConfig.mrc.pool = config.mrcPool;
    workerConfig.mrc.commit = true;
    workerConfig.mrc.lockFree = true;
    workerConfig.mds = config.mds;

    return workerConfig;
}

DetectSignConfig makeDetectSignConfig(const PlaygroundConfig& config)
{
    DetectSignConfig workerConfig;
    workerConfig.mrc.pool = config.mrcPool;
    workerConfig.mrc.commit = true;
    workerConfig.mrc.lockFree = true;
    workerConfig.yt.client = config.yt;
    workerConfig.yt.frameLoader = config.frameLoader;
    workerConfig.yt.useGpu = true;
    workerConfig.yt.portoLayerPath = std::string(yt::DEFAULT_GPU_PORTO_LAYER);
    workerConfig.yt.rootPath = "//home/maps/core/mrc/playground/eye-sign-cluster-" + config.hash;
    workerConfig.yt.partitionSize = 50;
    workerConfig.yt.concurrency = 50;
    workerConfig.yt.commit = false;
    workerConfig.yt.poolType = YT_POOL_TYPE;

    return workerConfig;
}

SyncDetectionConfig makeSyncDetectionConfig(const PlaygroundConfig& config)
{
    SyncDetectionConfig workerConfig;
    workerConfig.mrc.pool = config.mrcPool;
    workerConfig.mrc.commit = true;
    workerConfig.mrc.lockFree = true;
    workerConfig.detectionTypes = {db::eye::DetectionType::Sign};

    return workerConfig;
}

ObjectManagerConfig makeObjectManagerConfig(const PlaygroundConfig& config)
{
    ObjectManagerConfig workerConfig;
    workerConfig.mrc.pool = config.mrcPool;
    workerConfig.mrc.commit = true;
    workerConfig.mrc.lockFree = true;
    workerConfig.detectionTypes = {db::eye::DetectionType::Sign};
    workerConfig.frameMatcher =
        std::make_shared<FrameSuperpointsMatcher>(
            config.yt,
            *config.frameLoader,
            true /* useGpu */,
            YT_POOL_TYPE
        );
    workerConfig.detectionMatcher =
        std::make_shared<PositionDetectionMatcher>();
    workerConfig.clusterizer = std::make_shared<PositionDetectionClusterizer>();
    workerConfig.visibilityPredictor = std::make_shared<DummyVisibilityPredictor>();
    workerConfig.geoIdProvider = config.geoIdProvider;

    return workerConfig;
}

} // namespace maps::mrc::eye
