#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_sign/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/import_mrc/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/object_manager/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/sync_detection/include/config.h>

#include <maps/libs/pgpool/include/pgpool3.h>

#include <mapreduce/yt/interface/client.h>

#include <string>

namespace maps::mrc::eye {

struct PlaygroundConfig {
    PlaygroundConfig();

    // Fixed random string, used as unique id for yt pathes and etc
    std::string hash;
    pgpool3::Pool* mrcPool{nullptr};
    mds::Mds* mds{nullptr};
    FrameLoader* frameLoader{nullptr};
    NYT::IClientBase* yt{nullptr};
    TString ytRootPath{"//tmp"};
    privacy::GeoIdProviderPtr geoIdProvider{nullptr};
};

bool isValid(const PlaygroundConfig& config);

ImportMrcConfig makeImportMrcConfig(const PlaygroundConfig& config);

DetectSignConfig makeDetectSignConfig(const PlaygroundConfig& config);

SyncDetectionConfig makeSyncDetectionConfig(const PlaygroundConfig& config);

ObjectManagerConfig makeObjectManagerConfig(const PlaygroundConfig& config);

} // namespace maps::mrc::eye
