#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>

#include <string>
#include <tuple>
#include <vector>


namespace maps::mrc::eye {

struct FeatureObjectId {
    db::TId featureId;
    db::TId objectId;

    FeatureObjectId(db::TId featureId, db::TId objectId)
        : featureId(featureId)
        , objectId(objectId)
    {}

    auto introspect() const { return std::tie(featureId, objectId); }
};

using FeatureObjectIds = std::vector<FeatureObjectId>;

inline bool operator==(const FeatureObjectId& lhs, const FeatureObjectId& rhs)
{
    return lhs.introspect() == rhs.introspect();
}

inline bool operator<(const FeatureObjectId& lhs, const FeatureObjectId& rhs)
{
    return lhs.introspect() < rhs.introspect();
}

} // namespace maps::mrc::eye