#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/detection/include/match.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/playground/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/playground/include/feature_object_id.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/id.h>

#include <map>
#include <string>

namespace maps::mrc::eye {

class Playground {

public:
    Playground(const PlaygroundConfig& config);

    Playground& uploadMrcFeature(const std::string& featureTableYtPath);
    Playground& uploadSignRecognition(const std::string& detectionJsonPath);

    db::IdTo<db::TId> loadExternalFeatureIdToFrameId();
    std::map<FeatureObjectId, db::TId> loadFeatureObjectIdToSignDetectionId(const std::string& detectionJsonPath);

    Playground& runImportMrc();
    Playground& runDetectSign();
    Playground& runSyncDetection();
    Playground& runObjectManager();

    Playground& runObjectManager(
            const std::string& importDetectionsJsonPath,
            const std::string& importMatchesJsonPath);

    Playground& dumpDetectionsAsJson(const std::string& path, db::eye::DetectionType type);
    Playground& dumpClustersAsJson(const std::string& path, db::eye::DetectionType type);
    Playground& dumpMatchesAsJson(const std::string& path);

    Playground& dumpClustersAsGeoJson(const std::string& path, db::eye::DetectionType type);

protected:
    db::TId getFeatureId(db::TId externalFeatureId) const;
    db::TId getExternalFeatureId(db::TId featureId) const;

    db::IdTo<db::TId> loadFrameIdToFeatureId(pqxx::transaction_base& txn);
    db::IdTo<db::TId> loadFeatureIdToFrameId(pqxx::transaction_base& txn);

    db::IdTo<db::eye::Frame> loadFrameById(pqxx::transaction_base& txn);

    db::IdTo<db::TId> loadDetectionIdToGroupId(pqxx::transaction_base& txn);
    db::IdTo<db::TId> loadGroupIdToFrameId(pqxx::transaction_base& txn);

private:
    PlaygroundConfig config_;
    std::string hash_;

    db::IdTo<db::TId> externalFeatureIdToFeatureId_;
    db::IdTo<db::TId> featureIdToExternalFeatureId_;
    MatchedFrameDetections matches_;
};

} // namespace maps::mrc::eye
