#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/toloka/task.h>

#include <maps/libs/pgpool/include/pgpool3.h>

namespace maps::mrc::eye {

class TolokaRecognitionContext {
public:
    TolokaRecognitionContext(
        pqxx::transaction_base& txn,
        const db::eye::Recognitions& recognitions);

    const db::eye::Frame& getFrame(const db::eye::Recognition& recognition) const;

    db::FeaturePrivacy getFramePrivacy(const db::eye::Recognition& recognition) const;

    db::toloka::Tasks getTolokaTasks(const db::eye::Recognition& recognition) const;

    db::eye::RecognitionTasks getRecognitionTasks(const db::eye::Recognition& recognition) const;

    const db::toloka::Task& getTolokaTask(const db::eye::RecognitionTask& recognitionTask) const;

private:
    std::map<db::TId, db::eye::Frame> frameIdToFrame_;
    std::map<db::TId, db::FeaturePrivacy> frameIdToPrivacy_;
    std::map<db::TId, db::eye::RecognitionTasks> recognitionIdToRecognitionTasks_;
    std::map<db::TId, db::toloka::Task> recognitionTaskIdToTolokaTask_;
};

} // namespace maps::mrc::eye
