#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/toloka/task_gateway.h>

#include <maps/libs/pgpool/include/pgpool3.h>

namespace maps::mrc::eye {

struct Batch {
    db::TId beginTxnId;
    db::TId endTxnId;

    db::eye::Recognitions recognitions;
};

std::map<db::eye::RecognitionType, db::eye::Recognitions>
splitRecognitionsByType(db::eye::Recognitions recognitions);

Batch getNewRecognitionsBatch(
    pqxx::transaction_base& txn,
    const db::eye::RecognitionTypes& recognitionTypes,
    db::TId beginTxnId,
    size_t batchSize);

db::eye::Recognitions getUnprocessedRecognitions(
    pqxx::transaction_base& txn,
    const db::eye::RecognitionTypes& recognitionTypes,
    const db::TIds& recognitionIds);

bool isCompleted(const db::toloka::Task& task);

} // namespace maps::mrc::eye
