#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition.h>

#include <maps/libs/pgpool3utils/include/yandex/maps/pgpool3utils/pg_advisory_mutex.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/recognition_task/include/config.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/base_worker.h>

#include <map>
#include <optional>

namespace maps::mrc::eye {

using RecognitionTaskHandler
    = std::function<size_t(
        pqxx::transaction_base&,
        const FrameUrlResolver&,
        const db::eye::Recognitions&)>;

class RecognitionTaskManager
    : public BaseMrcWorkerWithConfig<
        RecognitionTaskManagerConfig,
        common::LockId::EyeRecognitionTaskManager>
{
public:
    RecognitionTaskManager(const RecognitionTaskManagerConfig& config);

    void processBatch(const db::TIds& recognitionIds) override;

    bool processBatchInLoopMode(size_t size) override;

private:
    size_t process(
        pqxx::transaction_base& txn,
        db::eye::Recognitions recognitions);

    std::map<db::eye::RecognitionType, RecognitionTaskHandler> typeToHandler_;
};

} // namespace maps::mrc::eye
