#include <maps/wikimap/mapspro/services/mrc/eye/lib/recognition_task/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/recognition_task/tests/fixture.h>

using namespace maps::mrc::db::eye;

namespace maps::mrc::eye::tests {

TEST_F(Fixture, invalid_config_without_pool)
{
    FrameUrlResolver urlResolver(
        "http://fake-browser-mrc.yandex.ru",
        "http://fake-browser-pro-mrc.yandex.ru");

    RecognitionTaskManagerConfig config;

    EXPECT_TRUE(!isValid(config));

    EXPECT_EQ(config.mrc.lockFree, false);
    EXPECT_EQ(config.mrc.commit, false);

    config.mrc.lockFree = false;
    config.mrc.commit = true;
    config.frameUrlResolver = &urlResolver;
    config.recognitionTypes = {RecognitionType::DetectTrafficLight};

    EXPECT_EQ(config.mrc.lockFree, false);
    EXPECT_EQ(config.mrc.commit, true);
    EXPECT_EQ(config.frameUrlResolver, &urlResolver);

    EXPECT_TRUE(!isValid(config));
}

TEST_F(Fixture, valid_config)
{
    FrameUrlResolver urlResolver(
        "http://fake-browser-mrc.yandex.ru",
        "http://fake-browser-pro-mrc.yandex.ru");

    RecognitionTaskManagerConfig config;

    EXPECT_TRUE(!isValid(config));

    EXPECT_EQ(config.mrc.lockFree, false);
    EXPECT_EQ(config.mrc.commit, false);

    config.mrc.lockFree = true;
    config.mrc.commit = false;
    config.mrc.pool = &pool();
    config.frameUrlResolver = &urlResolver;
    config.recognitionTypes = {RecognitionType::DetectTrafficLight};

    EXPECT_EQ(config.mrc.lockFree, true);
    EXPECT_EQ(config.mrc.commit, false);
    EXPECT_EQ(config.mrc.pool, &pool());
    EXPECT_EQ(config.frameUrlResolver, &urlResolver);

    EXPECT_TRUE(isValid(config));
}

} // namespace maps::mrc::eye::tests
