#include <maps/wikimap/mapspro/services/mrc/eye/lib/recognition_task/impl/context.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/recognition_task/tests/fixture.h>

using namespace maps::mrc::db::eye;
using namespace maps::mrc::db::toloka;

namespace maps::mrc::eye::tests {

TEST_F(Fixture, create_context_test)
{
    auto txn = txnHandle();

    // prepare database
    Recognitions recognitions = {
        {
            frames[0].id(),
            common::ImageOrientation(common::Rotation::CW_0),
            RecognitionType::DetectTrafficLight,
            RecognitionSource::Toloka,
            1
        },
        {
            frames[2].id(),
            common::ImageOrientation(common::Rotation::CW_180),
            RecognitionType::DetectTrafficLight,
            RecognitionSource::Toloka,
            1
        },
    };
    RecognitionGateway(*txn).insertx(recognitions);

    Task task(db::toloka::Platform::Toloka);
    task.setType(TaskType::TrafficLightDetection)
        .setStatus(TaskStatus::Finished)
        .setInputValues(R"({"image": "https://yandex.ru/image-1"})")
        .setOutputValues(R"({"polygons": [[[10, 10], [20, 20]]]})");
    TaskGateway(*txn).insertx(task);

    RecognitionTask recognitionTask(recognitions[0].id(), task.id());
    RecognitionTaskGateway(*txn).insertx(recognitionTask);

    // test
    TolokaRecognitionContext context(*txn, recognitions);

    const Frame frame2 = context.getFrame(recognitions[1]);
    EXPECT_EQ(frame2.id(), frames[2].id());

    db::toloka::Tasks tolokaTasks = context.getTolokaTasks(recognitions[0]);
    EXPECT_EQ(tolokaTasks.size(), 1u);
    EXPECT_EQ(tolokaTasks.front().id(), task.id());
}

} // namespace maps::mrc::eye::tests
