#include <maps/wikimap/mapspro/services/mrc/eye/lib/recognition_task/tests/fixture.h>

using namespace maps::mrc::db::toloka;
using namespace maps::mrc::db::eye;

namespace maps::mrc::eye::tests {

Fixture::Fixture() {
    {
        auto txn = txnHandle();

        devices = {
            Device(MrcDeviceAttrs{"M1"}),
            Device(MrcDeviceAttrs{"M2"}),
            Device(MrcDeviceAttrs{"M3"}),
        };
        DeviceGateway(*txn).insertx(devices);

        txn->commit();
    }

    {
        auto txn = txnHandle();

        frames = {
            {
                devices[0].id(),
                common::ImageOrientation(common::Rotation::CW_0),
                MrcUrlContext{1, "1", "1"},
                {1280, 720},
                chrono::parseSqlDateTime("2017-05-06 07:01:15+03")
            },
            {
                devices[1].id(),
                common::ImageOrientation(common::Rotation::CW_90),
                MrcUrlContext{4, "4", "4"},
                {1280, 720},
                chrono::parseSqlDateTime("2016-04-02 05:57:11+03")
            },
            {
                devices[1].id(),
                common::ImageOrientation(common::Rotation::CW_90),
                MrcUrlContext{4, "5", "5"},
                {1280, 720},
                chrono::parseSqlDateTime("2016-04-02 05:58:11+03")
            },
        };
        FrameGateway(*txn).insertx(frames);

        txn->commit();
    }

    {
        auto txn = txnHandle();

        privacies = {
            {
                frames[0].id(),
                db::FeaturePrivacy::Public
            },
            {
                frames[1].id(),
                db::FeaturePrivacy::Public
            },
            {
                frames[2].id(),
                db::FeaturePrivacy::Public
            }
        };
        FramePrivacyGateway(*txn).insertx(privacies);

        txn->commit();
    }
}

} // namespace maps::mrc::eye::tests
