#include <maps/libs/http/include/test_utils.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/recognition_task/impl/traffic_light_handler.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/recognition_task/tests/fixture.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition_value.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/toloka/task_gateway.h>

using namespace maps::mrc::db::eye;
using namespace maps::mrc::db::toloka;

namespace maps::mrc::eye::tests {

TEST_F(Fixture, process_ready_recognition_test)
{
    auto txn = txnHandle();

    // prepare database
    Recognitions recognitions{
        {
            frames[0].id(),
            common::ImageOrientation(common::Rotation::CW_0),
            RecognitionType::DetectTrafficLight,
            RecognitionSource::Toloka,
            1
        }
    };
    RecognitionGateway(*txn).insertx(recognitions);

    Task task(db::toloka::Platform::Toloka);
    task.setType(TaskType::TrafficLightDetection)
        .setStatus(TaskStatus::Finished)
        .setInputValues(R"({"image": "https://yandex.ru/image-1"})")
        .setOutputValues(R"(
            {
                "result": "is_not_empty",
                "polygons": [
                    {
                        "type": "rectangle",
                        "data": {
                            "p1": {"x": 0.0078125, "y": 0.013888889},
                            "p2": {"x": 0.0156250, "y": 0.027777778}}
                    }
                ]
            }
        )");
    TaskGateway(*txn).insertx(task);

    RecognitionTask recognitionTask(recognitions[0].id(), task.id());
    RecognitionTaskGateway(*txn).insertx(recognitionTask);

    // test
    FrameUrlResolver urlResolver(
        "http://fake-browser-mrc.yandex.ru",
        "http://fake-browser-pro-mrc.yandex.ru");

    size_t updatesNumber = handleTrafficLightRecognitions(*txn, urlResolver, recognitions);

    EXPECT_EQ(updatesNumber, 1u);

    {
        Recognition recognition = RecognitionGateway(*txn).loadById(recognitions[0].id());
        EXPECT_TRUE(recognition.hasValue());
        EXPECT_EQ(
            recognition.value<DetectedTrafficLights>().size(),
            1u
        );
        EXPECT_EQ(
            recognition.value<DetectedTrafficLights>()[0].box,
            common::ImageBox(10, 10, 20, 20)
        );
    }
}

TEST_F(Fixture, process_new_recognition_test)
{
    auto txn = txnHandle();

    // prepare database
    Recognitions recognitions = {
        {
            frames[0].id(),
            common::ImageOrientation(common::Rotation::CW_0),
            RecognitionType::DetectTrafficLight,
            RecognitionSource::Toloka,
            1
        },
    };
    RecognitionGateway(*txn).insertx(recognitions);

    // test
    FrameUrlResolver urlResolver(
        "http://fake-browser-mrc.yandex.ru",
        "http://fake-browser-pro-mrc.yandex.ru");

    size_t updatesNumber = handleTrafficLightRecognitions(*txn, urlResolver, recognitions);

    EXPECT_EQ(updatesNumber, 1u);

    {
        RecognitionTasks recognitionTasks = RecognitionTaskGateway(*txn).load(
            db::eye::table::RecognitionTask::recognitionId == recognitions[0].id()
        );
        EXPECT_EQ(recognitionTasks.size(), 1u);
        RecognitionTask& recognitionTask = recognitionTasks[0];
        db::toloka::Task task = db::toloka::TaskGateway(*txn).loadById(recognitionTask.taskId());

        task.setOutputValues(R"(
            {
                "result": "is_not_empty",
                "polygons": [
                    {
                        "type": "rectangle",
                        "data": {
                            "p1": {"x": 0.0156250, "y": 0.027777778},
                            "p2": {"x": 0.0234375, "y": 0.041666667}
                        }
                    }
                ]
            }
        )");
        db::toloka::TaskGateway(*txn).updatex(task);
    }

    updatesNumber = handleTrafficLightRecognitions(*txn, urlResolver, recognitions);

    EXPECT_EQ(updatesNumber, 1u);

    {
        Recognition recognition = RecognitionGateway(*txn).loadById(recognitions[0].id());
        EXPECT_TRUE(recognition.hasValue());
        EXPECT_EQ(
            recognition.value<DetectedTrafficLights>().size(),
            1u
        );
        EXPECT_EQ(
            recognition.value<DetectedTrafficLights>()[0].box,
            common::revertByImageOrientation(
                common::ImageBox(20, 20, 30, 30),
                frames[0].originalSize(),
                recognitions[0].orientation()
            )
        );
    }
}

} // namespace maps::mrc::eye::tests
