#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition.h>

#include <pqxx/pqxx>

namespace maps::mrc::eye {

struct BatchItem {
    // Кадр на котором нужно обновить детекции и связи между ними
    db::eye::Frame frame;
    // Набор распознаваний для соответствующего фрейма.
    // Все распознавания имеют один и тот же тип и ориентацию, равную ориентации фрейма
    db::eye::Recognitions recognitions;
    // Группа детекций для соответствующего кадра.
    // Ее может не быть, если для этого кадра еще ни разу не запускался sync,
    // в противном случае она уже есть и ее надо обновить (поднять txn_id)
    std::optional<db::eye::DetectionGroup> group;
    // Набор существующих детекций на кадре. Этот набор может быть пустой в двух случаях:
    //  1) sync еще не запускался для этого кадра
    //  2) при предыдущем синке не было добавлено ни одной детекции
    db::eye::Detections detections;
    // Набор существующих связей между существующими детекциями
    db::eye::DetectionRelations relations;
};

using BatchItems = std::vector<BatchItem>;

struct Batch {
    BatchItems items;
    db::TId beginTxnId;
    db::TId endTxnId;
};

Batch getNewBatch(
    pqxx::transaction_base& txn,
    db::TId beginTxnId,
    const db::eye::DetectionTypes& detectionTypes,
    size_t limit);

BatchItems getBatchItems(
    pqxx::transaction_base& txn,
    const db::TIds& frameIds,
    const db::eye::DetectionTypes& detectionTypes);

} // maps::mrc::eye
