#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/sync_detection/impl/batch.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition.h>

#include <pqxx/pqxx>

namespace maps::mrc::eye {

struct UpdatedDetections {
    db::eye::Detections unchanged;
    db::eye::Detections updated;

    bool approved;
};

UpdatedDetections makeUpdatedDetections(
        const db::eye::DetectionGroup& group,
        const db::eye::Detections& detections,
        const db::eye::Recognitions& recognitions);

struct UpdatedRelations {
    db::eye::DetectionRelations unchanged;
    db::eye::DetectionRelations changed;
};

UpdatedRelations makeUpdatedRelations(
        const db::eye::Frame& frame,
        const db::eye::Detections& detections,
        const db::eye::DetectionRelations& relations);

// Сверяем источник со списком источников, recognition
// из которых можно удалить после sync
bool mayBeRemoved(db::eye::RecognitionSource source);

void sync(pqxx::transaction_base& txn, BatchItems items);

} // maps::mrc::eye
