#include <maps/wikimap/mapspro/services/mrc/eye/lib/sync_detection/impl/sync.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/sync_detection/include/sync_detection.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/sync_detection/include/metadata.h>

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/pg_locks.h>

#include <maps/libs/log8/include/log8.h>

#include <pqxx/pqxx>


namespace maps::mrc::eye {

void SyncDetection::processBatch(const db::TIds& frameIds)
{
    const auto lock = lockIfNeed();

    auto txn = config_.mrc.pool->masterWriteableTransaction();

    auto items = getBatchItems(*txn, frameIds, config_.detectionTypes);
    sync(*txn, std::move(items));

    commitIfNeed(*txn);
}

bool SyncDetection::processBatchInLoopMode(size_t size)
{
    const auto lock = lockIfNeed();

    auto txn = config_.mrc.pool->masterWriteableTransaction();
    auto metadata = syncDetectionMetadata(*txn);

    const auto batch = getNewBatch(*txn,metadata.getTxnId(), config_.detectionTypes, size);

    INFO() << "Batch size " << batch.items.size()
           << " [" << batch.beginTxnId << ", " << batch.endTxnId<< ")";

    sync(*txn, std::move(batch.items));

    metadata.updateTxnId(batch.endTxnId);
    metadata.updateTime();

    commitIfNeed(*txn);

    return batch.beginTxnId != batch.endTxnId;
}

} // namespace maps::mrc::eye
