#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/base_worker.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/sync_detection/include/config.h>

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/pg_locks.h>

namespace maps::mrc::eye {

// The service transform recognitions from eye.recognition to normalized
// form of eye.{detection_group, detection, detection_relation} tables.
// For each frame it takes all the non-deleted recognitions from all the
// sources and merges them into unique integral set of recognitions.
// Then it estimates relations between them and updates data in the database.

// Input tables:
//  - eye.recognition
//  - eye.frame
// Output tables:
//  - eye.detection_group
//  - eye.detection
//  - eue.detection_relation

class SyncDetection: public BaseMrcWorkerWithConfig<SyncDetectionConfig, common::LockId::EyeSyncDetection> {

public:
    using BaseMrcWorkerWithConfig::BaseMrcWorkerWithConfig;

    void processBatch(const db::TIds& frameIds) override;

    // Set last txn id and sync time
    bool processBatchInLoopMode(size_t size) override;
};

} // namespace maps::mrc::eye
