#include <mapreduce/yt/tests/yt_unittest_lib/yt_unittest_lib.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/sync_detection/impl/batch.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/sync_detection/tests/common.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/sync_detection/tests/fixture.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition_gateway.h>

namespace maps::mrc::eye::tests {

TEST_F(Fixture, get_batch)
{
    db::TId beginTxnId = 0;
    const db::eye::DetectionTypes detectionTypes = {
        db::eye::DetectionType::Sign,
        db::eye::DetectionType::TrafficLight,
        db::eye::DetectionType::HouseNumber,
    };
    const size_t limit = 100;

    auto txn = newTxn();
    auto batch = getNewBatch(*txn, beginTxnId, detectionTypes, limit);

    EXPECT_EQ(batch.items.size(), 6u);

    std::sort(batch.items.begin(), batch.items.end(),
        [](const auto& lhs, const auto& rhs) {
            return std::make_pair(lhs.frame.id(), lhs.recognitions.at(0).type())
                 < std::make_pair(rhs.frame.id(), rhs.recognitions.at(0).type());
        }
    );

    EXPECT_EQ(batch.items[0].frame.id(), frames[0].id());
    EXPECT_EQ(batch.items[0].frame.deleted(), false);
    EXPECT_EQ(batch.items[0].group.has_value(), false);
    EXPECT_EQ(batch.items[0].recognitions.size(), 1u);
    EXPECT_EQ(batch.items[0].detections.size(), 0u);
    EXPECT_EQ(batch.items[0].relations.size(), 0u);

    EXPECT_EQ(batch.items[1].frame.id(), frames[0].id());
    EXPECT_EQ(batch.items[1].frame.deleted(), false);
    EXPECT_EQ(batch.items[1].group.has_value(), false);
    EXPECT_EQ(batch.items[1].recognitions.size(), 1u);
    EXPECT_EQ(batch.items[1].detections.size(), 0u);
    EXPECT_EQ(batch.items[1].relations.size(), 0u);

    EXPECT_EQ(batch.items[2].frame.id(), frames[1].id());
    EXPECT_EQ(batch.items[2].frame.deleted(), false);
    EXPECT_EQ(batch.items[2].group.has_value(), false);
    EXPECT_EQ(batch.items[2].recognitions.size(), 1u);
    EXPECT_EQ(batch.items[2].detections.size(), 0u);
    EXPECT_EQ(batch.items[2].relations.size(), 0u);

    EXPECT_EQ(batch.items[3].frame.id(), frames[3].id());
    EXPECT_EQ(batch.items[3].frame.deleted(), false);
    EXPECT_EQ(batch.items[3].group.has_value(), true);
    EXPECT_EQ(batch.items[3].recognitions.size(), 2u);
    EXPECT_EQ(batch.items[3].detections.size(), 2u);
    EXPECT_EQ(batch.items[3].relations.size(), 0u);

    EXPECT_EQ(batch.items[4].frame.id(), frames[5].id());
    EXPECT_EQ(batch.items[4].frame.deleted(), true);
    EXPECT_EQ(batch.items[4].group.has_value(), false);
    EXPECT_EQ(batch.items[4].recognitions.size(), 1u);
    EXPECT_EQ(batch.items[4].detections.size(), 0u);
    EXPECT_EQ(batch.items[4].relations.size(), 0u);

    EXPECT_EQ(batch.items[5].frame.id(), frames[6].id());
    EXPECT_EQ(batch.items[5].frame.deleted(), false);
    EXPECT_EQ(batch.items[5].group.has_value(), true);
    EXPECT_EQ(batch.items[5].recognitions.size(), 1u);
    EXPECT_EQ(batch.items[5].detections.size(), 1u);
    EXPECT_EQ(batch.items[5].relations.size(), 0u);
}

} // namespace maps::mrc::eye::tests
