#include <maps/wikimap/mapspro/services/mrc/eye/lib/sync_detection/tests/common.h>

#include <algorithm>

namespace maps::mrc::eye::tests {

bool checkDetectionFromGroup(
        const db::eye::DetectionGroup& group,
        const db::eye::Detections& detections)
{
    return std::all_of(
        detections.begin(), detections.end(),
        [&](const auto& detection) {
            return detection.groupId() == group.id();
        }
    );
}

bool hasDetectedTrafficLight(const db::eye::Detections& detections, const common::ImageBox& box)
{
    return std::any_of(
        detections.begin(), detections.end(),
        [&](const db::eye::Detection& detection)
        {   const auto attrs = detection.attrs<db::eye::DetectedTrafficLight>();
            return attrs.box == box
                and not detection.deleted();
        }
    );
}

bool hasDetectedSign(
        const db::eye::Detections& detections,
        traffic_signs::TrafficSign type,
        const common::ImageBox& box)
{
    return std::any_of(
        detections.begin(), detections.end(),
        [&](const db::eye::Detection& detection)
        {   const auto attrs = detection.attrs<db::eye::DetectedSign>();
            return attrs.box == box
                and attrs.type == type
                and not detection.deleted();
        }
    );
}

bool hasDetectedRoadMarking(
        const db::eye::Detections& detections,
        traffic_signs::TrafficSign type,
        const common::ImageBox& box)
{
    return std::any_of(
        detections.begin(), detections.end(),
        [&](const db::eye::Detection& detection)
        {   const auto attrs = detection.attrs<db::eye::DetectedRoadMarking>();
            return attrs.box == box
                and attrs.type == type
                and not detection.deleted();
        }
    );
}

bool hasDetectedHouseNumber(
        const db::eye::Detections& detections,
        const std::string& number,
        const common::ImageBox& box)
{
    return std::any_of(
        detections.begin(), detections.end(),
        [&](const db::eye::Detection& detection)
        {   const auto attrs = detection.attrs<db::eye::DetectedHouseNumber>();
            return attrs.box == box
                and attrs.number == number
                and not detection.deleted();
        }
    );
}

bool isDeleted(const db::eye::Detections& detections, db::TId id)
{
    return std::any_of(
        detections.begin(), detections.end(),
        [&](const auto& detection) {
            return detection.id() == id and detection.deleted();
        }
    );
}

} //  namespace maps::mrc::eye::tests
