#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/image_box.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition.h>

namespace maps::mrc::eye::tests {

bool checkDetectionFromGroup(const db::eye::DetectionGroup& group, const db::eye::Detections& detections);

bool hasDetectedTrafficLight(const db::eye::Detections& detections, const common::ImageBox& box);

bool hasDetectedSign(
        const db::eye::Detections& detections,
        traffic_signs::TrafficSign type,
        const common::ImageBox& box);

bool hasDetectedRoadMarking(
        const db::eye::Detections& detections,
        traffic_signs::TrafficSign type,
        const common::ImageBox& box);

bool hasDetectedHouseNumber(
        const db::eye::Detections& detections,
        const std::string& name,
        const common::ImageBox& box);

bool isDeleted(const db::eye::Detections& detections, db::TId id);

} // namespace maps::mrc::eye::tests