#include <maps/wikimap/mapspro/services/mrc/eye/lib/sync_detection/tests/fixture.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/unit_test/include/frame.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition_gateway.h>

namespace maps::mrc::eye::tests {

BaseFixture::BaseFixture()
    : device(db::eye::MrcDeviceAttrs{"M1"})
{
    auto txn = newTxn();
    db::eye::DeviceGateway(*txn).upsertx(device);
    txn->commit();
}

BaseFixture::~BaseFixture() { playground().postgres().truncateTables(); }

GroupWithDetections BaseFixture::getGroup(db::TId frameId, db::eye::DetectionType type) const
{
    auto txn = newTxn();

    auto group = db::eye::DetectionGroupGateway(*txn).loadOne(
        db::eye::table::DetectionGroup::frameId == frameId
            and db::eye::table::DetectionGroup::type == type
    );

    auto detections = db::eye::DetectionGateway(*txn).load(
        db::eye::table::Detection::groupId == group.id()
    );

    return {group, detections};
}


Fixture::Fixture()
{
    auto insertFrames = [&](size_t begin, size_t end) {
        auto txn = newTxn();

        TArrayRef ref(frames.data() + begin, frames.data() + end);
        db::eye::FrameGateway(*txn).insertx(ref);

        txn->commit();

    };

    const common::Size imageSize {640, 480};
    const int VERSION = 1;

    {   // create frames
        const db::TId deviceId = device.id();

        frames = {
            {deviceId, identical, makeUrlContext(1, "1"), imageSize, time()},
            {deviceId, onLeftSide, makeUrlContext(2, "2"), imageSize, time()},
            {deviceId, onLeftSide, makeUrlContext(3, "3"), imageSize, time()},
            {deviceId, identical, makeUrlContext(4, "4"), imageSize, time()},
            {deviceId, identical, makeUrlContext(5, "5"), imageSize, time()},
            {deviceId, identical, makeUrlContext(6, "6"), imageSize, time()},
            {deviceId, identical, makeUrlContext(7, "7"), imageSize, time()},
            {deviceId, identical, makeUrlContext(8, "8"), imageSize, time()},
        };

        frames[5].setDeleted(true);

        insertFrames(0, 3);
        insertFrames(3, 6);
        insertFrames(6, 8);
    }

    auto insertRecognitions = [&](size_t begin, size_t end)
    {
        auto txn = newTxn();

        TArrayRef ref(recognitions.data() + begin, recognitions.data() + end);
        db::eye::RecognitionGateway(*txn).insertx(ref);

        txn->commit();
    };

    {   // create recognitions
        recognitions = {
            {
                frames[0].id(),
                frames[0].orientation(),
                db::eye::RecognitionType::DetectSign,
                db::eye::RecognitionSource::Import,
                VERSION,
                db::eye::DetectedSigns {
                    db::eye::DetectedSign {
                        revertByImageOrientation({100, 100, 200, 200}, imageSize, frames[0].orientation()),
                        traffic_signs::TrafficSign::ProhibitoryNoEntry,
                        0.9,
                        false,
                        0.95
                    }
                }
            },
            {
                frames[0].id(),
                frames[0].orientation(),
                db::eye::RecognitionType::DetectTrafficLight,
                db::eye::RecognitionSource::Import,
                VERSION,
                db::eye::DetectedTrafficLights {}
            },
            {
                frames[1].id(),
                frames[1].orientation(),
                db::eye::RecognitionType::DetectSign,
                db::eye::RecognitionSource::Import,
                VERSION,
                db::eye::DetectedSigns {
                    db::eye::DetectedSign {
                        {100, 100, 200, 200},
                        traffic_signs::TrafficSign::ProhibitoryNoEntry,
                        0.9,
                        false,
                        0.95
                    }
                }
            },
            {
                frames[3].id(),
                frames[3].orientation(),
                db::eye::RecognitionType::DetectTrafficLight,
                db::eye::RecognitionSource::Import,
                VERSION,
                db::eye::DetectedTrafficLights {
                    db::eye::DetectedTrafficLight {
                        {300, 100, 319, 120}, 0.92},
                    db::eye::DetectedTrafficLight {
                        {170, 171, 200, 200}, 0.91},
                }
            },
            {
                frames[3].id(),
                frames[3].orientation(),
                db::eye::RecognitionType::DetectTrafficLight,
                db::eye::RecognitionSource::Model,
                VERSION,
                db::eye::DetectedTrafficLights {
                    db::eye::DetectedTrafficLight {{100, 100, 120, 120}, 0.90},
                    db::eye::DetectedTrafficLight {{170, 170, 200, 200}, 0.91},
                }
            },
            {
                frames[3].id(),
                frames[3].orientation(),
                db::eye::RecognitionType::DetectTrafficLight,
                db::eye::RecognitionSource::Toloka,
                VERSION
            },
            {
                frames[5].id(),
                frames[5].orientation(),
                db::eye::RecognitionType::DetectTrafficLight,
                db::eye::RecognitionSource::Model,
                VERSION,
                db::eye::DetectedTrafficLights{}
            },
            {
                frames[6].id(),
                frames[6].orientation(),
                db::eye::RecognitionType::DetectTrafficLight,
                db::eye::RecognitionSource::Model,
                VERSION,
                db::eye::DetectedTrafficLights {
                    {{170, 171, 200, 200}, 0.98},
                }
            },
        };

        insertRecognitions(0, 6);
        insertRecognitions(6, 8);
    }

    { // create groups
        groups = {
            {frames[3].id(), db::eye::DetectionType::TrafficLight},
            {frames[6].id(), db::eye::DetectionType::TrafficLight}
        };

        auto txn = newTxn();
        db::eye::DetectionGroupGateway(*txn).insertx(groups);
        txn->commit();
    }

    {   // create detections
        detections = {
            {groups[0].id(), db::eye::DetectedTrafficLight{{300, 100, 319, 120}, 0.92}},
            {groups[0].id(), db::eye::DetectedTrafficLight{{170, 171, 200, 200}, 0.91}},
            {groups[1].id(), db::eye::DetectedTrafficLight{{170, 171, 200, 200}, 0.98}},
        };

        auto txn = newTxn();
        db::eye::DetectionGateway(*txn).insertx(detections);
        txn->commit();
    }
}

db::TIds Fixture::frameIdsAt(std::initializer_list<size_t> indexes) const
{
    db::TIds frameIds;

    for (size_t index: indexes)  {
        frameIds.push_back(frames[index].id());
    }

    return frameIds;
}

} // namespace maps::mrc::eye::tests
