#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/sync_detection/include/sync_detection.h>
#include <library/cpp/testing/gtest/gtest.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition.h>
#include <maps/wikimap/mapspro/services/mrc/libs/unittest/include/yandex/maps/mrc/unittest/database_fixture.h>
#include <maps/wikimap/mapspro/services/mrc/libs/unittest/include/yandex/maps/mrc/unittest/unittest_config.h>

#include <initializer_list>
#include <vector>

namespace maps::mrc::eye::tests {


inline auto& playground() {
    static unittest::WithUnittestConfig<unittest::DatabaseFixture> global;
    return global;
}

struct GroupWithDetections {
    db::eye::DetectionGroup group;
    db::eye::Detections detections;
};

struct BaseFixture: public testing::Test {
    BaseFixture();
    ~BaseFixture();

    const auto& config() const { return playground().config(); }

    auto& pool() const { return playground().pool(); }

    auto newTxn() const { return pool().masterWriteableTransaction(); }

    SyncDetectionConfig makeSyncDetectionConfig() {
        SyncDetectionConfig workerConfig;
        workerConfig.mrc.pool = &pool();
        workerConfig.mrc.commit = true;
        workerConfig.detectionTypes = {
            db::eye::DetectionType::Sign,
            db::eye::DetectionType::TrafficLight
        };
        return workerConfig;
    }

    GroupWithDetections getGroup(db::TId frameId, db::eye::DetectionType type) const;

    template<class Gateway, class T>
    auto insertx(std::vector<T> objects) {
        auto txn =  newTxn();
        Gateway(*txn).insertx(objects);
        txn->commit();

        return objects;
    }

    db::eye::Device device;
};

struct Fixture: public BaseFixture {
    Fixture();

    db::TIds frameIdsAt(std::initializer_list<size_t> indexes) const;

    db::eye::Frames frames;

    db::eye::Recognitions recognitions;
    db::eye::DetectionGroups groups;
    db::eye::Detections detections;
};

} // namespace maps::mrc::eye::tests

