#pragma once

#include "config.h"

#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/base_worker.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/config.h>

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/pg_locks.h>

namespace maps::mrc::eye {

/// Проверяет наличие объекта с одной фотографии на другой.
/// Входные таблицы:
///  - eye.verified_detection_missing_on_frame
/// Результирующие таблицы:
///  - eye.verified_detection_missing_on_frame
/// Вспомогательные таблицы:
///  - eye.verified_detection_missing_on_frame_to_toloka_task
///  - toloka.task
class DetectionMissingOnFrameVerifier
    : public BaseMrcWorkerWithConfig<
        DetectionMissingOnFrameVerifierConfig,
        common::LockId::EyeVerifyDetectionMissingOnFrame>
{
public:
    using BaseMrcWorkerWithConfig::BaseMrcWorkerWithConfig;

    void processBatch(const db::TIds& missingIds) override;

    bool processBatchInLoopMode(size_t size) override;

protected:
    size_t processMissings(pqxx::transaction_base& txn, const db::TIds& missingIds);
};

} // namespace maps::mrc::eye
