#include "fixture.h"
#include "toloka/platform.h"
#include "toloka/task_type_info.h"

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/object_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/toloka/task_type_info_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/location/include/rotation.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/unit_test/include/frame.h>

namespace maps::mrc::eye::tests {

namespace {

const common::Size IMAGE_SIZE{1200, 800};
const chrono::TimePoint START_TIME = chrono::parseSqlDateTime("2020-06-01 12:00:00");
const db::eye::MrcUrlContext URL_CONTEXT = makeUrlContext(1, "1");

db::eye::Frame makeFrame(db::TId deviceId) {
    return {deviceId, identical, URL_CONTEXT, IMAGE_SIZE, START_TIME};
}

const geolib3::Point2 POS{37, 55};

} // namespace

BaseFixture::~BaseFixture() { playground().postgres().truncateTables(); }

DetectionFixture::DetectionFixture()
{
    auto txn = newTxn();
    devices = {
        {db::eye::MrcDeviceAttrs{"M1"}},
    };
    db::eye::DeviceGateway(*txn).insertx(devices);

    frames = {
        makeFrame(devices[0].id()),
        makeFrame(devices[0].id()),
        makeFrame(devices[0].id()),
    };
    db::eye::FrameGateway(*txn).insertx(frames);

    for (const auto& frame : frames) {
        frameLocations.emplace_back(
            frame.id(), POS, toRotation(geolib3::Heading(90), identical)
        );

        groups.emplace_back(frame.id(), db::eye::DetectionType::Sign);
        framePrivacies.emplace_back(frame.id(), db::FeaturePrivacy::Public);
    }
    db::eye::FrameLocationGateway(*txn).insertx(frameLocations);
    db::eye::DetectionGroupGateway(*txn).insertx(groups);
    db::eye::FramePrivacyGateway(*txn).insertx(framePrivacies);

    for (const auto& group : groups) {
        detections.emplace_back(
            group.id(),
            db::eye::DetectedSign {
                .box = {0, 0, 10, 10},
                .type = traffic_signs::TrafficSign::ProhibitoryMaxSpeed10,
                .typeConfidence = 1.0,
                .temporary = false,
                .temporaryConfidence = 1.0
            }
        );
    }

    db::eye::DetectionGateway(*txn).insertx(detections);

    std::vector<db::toloka::TaskTypeInfo> taskTypeInfos{
        {db::toloka::Platform::Toloka, db::toloka::TaskType::DetectionMissingOnFrame},
        {db::toloka::Platform::Yang, db::toloka::TaskType::DetectionMissingOnFrame}
    };

    db::toloka::TaskTypeInfoGateway(*txn).upsert(taskTypeInfos);

    txn->commit();
}

} // namespace maps::mrc::eye::tests
