#pragma once

#include "../include/config.h"

#include <library/cpp/testing/gtest/gtest.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/verified_detection_missing_on_frame_gateway.h>

#include <maps/wikimap/mapspro/services/mrc/libs/unittest/include/yandex/maps/mrc/unittest/database_fixture.h>
#include <maps/wikimap/mapspro/services/mrc/libs/unittest/include/yandex/maps/mrc/unittest/unittest_config.h>

#include <initializer_list>
#include <vector>

namespace maps::mrc::eye::tests {


inline auto& playground() {
    static unittest::WithUnittestConfig<unittest::DatabaseFixture> global;
    return global;
}


struct BaseFixture: public testing::Test
    , public testing::WithParamInterface<db::eye::VerificationSource>
{
    BaseFixture()
        : frameUrl(
            "https://mrc-browser.maps.yandex.net",
            "https://mrc-browser-pro.maps.yandex.net")
    {}

    ~BaseFixture();

    const auto& config() const { return playground().config(); }

    auto& pool() const { return playground().pool(); }

    auto newTxn() const { return pool().masterWriteableTransaction(); }

    DetectionMissingOnFrameVerifierConfig makeDetectionMissingOnFrameVerifierConfig() {
        DetectionMissingOnFrameVerifierConfig config;
        config.mrc.pool = &pool();
        config.mrc.commit = true;
        config.frameUrlResolver = &frameUrl;
        return config;
    }

    FrameUrlResolver frameUrl;
};


struct DetectionFixture : public BaseFixture {

    DetectionFixture();

    db::eye::Devices devices;
    db::eye::Frames frames;
    db::eye::FrameLocations frameLocations;
    db::eye::FramePrivacies framePrivacies;
    db::eye::DetectionGroups groups;
    db::eye::Detections detections;
};


} // namespace maps::mrc::eye::tests
