#pragma once

#include "config.h"

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/verified_detection_pair_match.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/base_worker.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/config.h>

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/pg_locks.h>

namespace maps::mrc::eye {

/// Проверяет принадлежность пары детекций одному и тому же физическому объекту.
/// Входные таблицы:
///  - eye.verified_detection_pair_match
/// Результирующие таблицы:
///  - eye.verified_detection_pair_match
/// Вспомогательные таблицы:
///  - eye.verified_detection_pair_match_to_toloka_task
///  - toloka.task
class DetectionPairMatchVerifier
    : public BaseMrcWorkerWithConfig<
        DetectionPairMatchVerifierConfig,
        common::LockId::EyeVerifyDetectionPairMatch>
{
public:
    using BaseMrcWorkerWithConfig::BaseMrcWorkerWithConfig;

    void processBatch(const db::TIds& matchIds) override;

    bool processBatchInLoopMode(size_t size) override;

protected:
    size_t processMatches(pqxx::transaction_base& txn, const db::TIds& matchIds);
};

} // namespace maps::mrc::eye
