#include "common.h"
#include "eye/verification_source.h"
#include "fixture.h"

#include "../include/verify_detection_pair_match.h"
#include "toloka/platform.h"

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/verified_detection_pair_match_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/object_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/toloka/task_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/toloka_manager/include/detection_pair_match.h>

#include <maps/libs/log8/include/log8.h>
#include <maps/libs/introspection/include/stream_output.h>

using namespace testing;

namespace maps::mrc::db::eye {

using maps::introspection::operator<<;

} //namespace maps::mrc::db::eye


namespace maps::mrc::eye::tests {

TEST_P(DetectionFixture, toloka_task)
{
    const size_t limit = 10;
    auto workerConfig = makeDetectionPairMatchVerifierConfig();
    DetectionPairMatchVerifier verifier(workerConfig);

    const auto source = GetParam();

    db::eye::VerifiedDetectionPairMatch match{
        source,
        detections[0].id(),
        detections[1].id()};

    {
        auto txn = newTxn();
        db::eye::VerifiedDetectionPairMatchGateway(*txn).insertx(match);
        txn->commit();
    }

    size_t updatesNumber = verifier.processBatchInLoopMode(limit);
    EXPECT_EQ(updatesNumber, 1u);

    db::TId tolokaTaskId;
    {
        auto txn = newTxn();
        db::eye::VerifiedDetectionPairMatchesToTolokaTasks matchesToTasks =
            db::eye::VerifiedDetectionPairMatchToTolokaTaskGateway(*txn)
                .load();
        EXPECT_EQ(matchesToTasks.size(), 1u);
        EXPECT_EQ(matchesToTasks[0].verifiedTaskId(), match.id());

        tolokaTaskId = matchesToTasks[0].tolokaTaskId();

        db::toloka::Tasks tasks = db::toloka::TaskGateway(*txn).load(
            db::toloka::table::Task::id == tolokaTaskId);
        EXPECT_EQ(tasks.size(), 1u);
        auto expectedPlatform =
            source == db::eye::VerificationSource::Toloka
                ? db::toloka::Platform::Toloka
                : db::toloka::Platform::Yang;
        EXPECT_EQ(tasks[0].platform(), expectedPlatform);
        EXPECT_FALSE(tasks[0].outputValues().has_value());
    }

    {
        auto txn = newTxn();
        db::toloka::Tasks tasks = db::toloka::TaskGateway(*txn).load(
            db::toloka::table::Task::id == tolokaTaskId);

        toloka::DetectionPairMatchOutput output{
            toloka::DetectionPairMatchResult::Yes};
        std::stringstream ss;
        json::Builder builder(ss);
        builder << [&](json::ObjectBuilder b) { output.json(b); };

        tasks[0].setOutputValues(ss.str());

        db::toloka::TaskGateway(*txn).updatex(tasks);

        txn->commit();
    }

    updatesNumber = verifier.processBatchInLoopMode(limit);
    EXPECT_EQ(updatesNumber, 1u);

    {
        auto txn = newTxn();

        auto matches =
            db::eye::VerifiedDetectionPairMatchGateway(*txn).load();

        EXPECT_EQ(matches[0].detectionId1(), detections[0].id());
        EXPECT_EQ(matches[0].detectionId2(), detections[1].id());
        EXPECT_EQ(matches[0].approved().value(), true);
    }
}

INSTANTIATE_TEST_SUITE_P(
    TolokaTasksTests,
    DetectionFixture,
    ValuesIn({
        db::eye::VerificationSource::Toloka,
        db::eye::VerificationSource::Yang
    })
);

} // namespace maps::mrc::eye::tests
