Этот тул прездназначен для оценки качества генерируемых текущим кодом гипотез на основе исторических данных разбора ранее сгенерированных гипотез.

*Входные данные*
- `--mrc-config` -- конфиг MRC для загрузки данных об объектах-знаках и ранее сгененированных гипотезах
- `--wiki-config` -- конфиг Народной Карты для загрузки данных о результате разбора гипотез
- `bbox` -- область, внутри которой будет выполняться ревалидация
- `validate` -- тип валидации для проверки.

Пример вызова:
```
./test_hypotheses_quality --mrc-config ../../../libs/config/cfg/t-config.production.xml --secret-version sec-01fjesdh3jykc9s87detcnw9mr --wiki-config ~/configs/wiki/production/services.prod.xml --wiki-act-date 2021-10-01 --bbox 37.371687,55.583541~37.846846,55.917364 --validate wrong-speed-limit
```

*Алгоритм работы*

1. Из базы загружаются все объекты `objects`, находящиеся внутри `bbox`
2. Из `objects` исключаются объекты, к которым не применима валидация `validate`
3. Из базы загружаются ранее сгенерированные по этим объектам гипотезы `hypotheses` дополнительно загружатся из базы НК результаты их разбора: была ли гипотеза обработана и был ли по ней коммит.
4. Для каждого объекта из `objects`, по которому была ранее сгенерирована гипотеза выполняется валидация данных НК на состоянии базы Revision, предшествующем коммиту обработки гипотезы, в результате получается новый набор гипотез `new_hypotheses`.
5. Новые и старые гипотезы сматчиваются по `object_id` и атрибутам гипотезы.
6. Для старых и новых гипотез вычисляются показатели:
    - общее количество
    - количество обработанных
    - количество гипотез с коммитами
7. В результате вычисляется полезность для старых и новых гипотез, а также оценка доли "потерянных старых гипотез".


*Пример выходных данных*

```
Hypotheses statistics:
old cnt:	3664
old processed cnt:	3664
old processed with commits cnt:	590
new cnt:	3620
new matched:	3554
new matched processed:	3554
new matched processed with commits:	561
--------------------------------------------------------
old usefulness:	0.161026
new usefulness:	0.15785
usefull loss:	0.0491525
unmached ratio:	0.018232
```

*Как пользоваться тулом*
Предположим, есть ветка с изменениями в логике работы валидатора. Мы хотим проверить, качество валидации станет лучше или хуже по сравнению с текущим trunk-ом.
Для этого тул надо будет собрать и запустить с одинаковыми значениями параметров на trunk-ветке и на ветке с оцениваемыми изменениями.
Изменения в рабочей ветке можно считать хорошими, если выполняются все условия ниже:
- `branch.new usefulness >= trunk.new usefulness`
- `branch.usefull_loss <= trunk.usefull_loss`
