#pragma once

#include "eye/hypothesis.h"
#include "eye/object.h"
#include "maps/libs/chrono/include/time_point.h"
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/hypothesis.h>

#include <maps/libs/geolib/include/bounding_box.h>

#include <pqxx/transaction_base>

#include <vector>

namespace maps::mrc::eye::qa {

struct FeedbackResult {
    bool isFeedbackProcessed = false;
    bool hasCommits = false;
    std::optional<chrono::TimePoint> processedAt;
};

struct HypothesisWithFeedback {
    db::eye::Hypothesis hypothesis;
    db::TId objectId = 0;
    db::TId feedbackTaskId = 0;
    FeedbackResult result{};
};

struct HypothesesStatistics {
    size_t oldCnt{};
    size_t oldProcessedCnt{};
    size_t oldProcessedWithCommitsCnt{};
    size_t newCnt{};
    size_t newMatchedCnt{};
    size_t newMatchedProcessedCnt{};
    size_t newMatchedProcessedWithCommitsCnt{};
};

db::eye::Objects loadObjects(
    pqxx::transaction_base& txn, const geolib3::BoundingBox& mercBbox);

db::TId evalWikiRevisionCommitIdByDate(pqxx::transaction_base& txn, chrono::TimePoint date);

std::unordered_map<db::TId, FeedbackResult> loadFeedbackResult(
    pqxx::transaction_base& txn, const db::TIds& fedbackTaskIds);

std::vector<HypothesisWithFeedback> loadHypothesesWithFeedback(
    pqxx::transaction_base& mrcTxn,
    pqxx::transaction_base& socialTxn,
    const db::TIds& objectIds);

db::TIdSet objectIdsSet(const std::vector<HypothesisWithFeedback>& hypotheses);

db::TIds collectFeedbackTaskIds(
    pqxx::transaction_base& txn, const db::eye::Hypotheses& hypotheses);

HypothesesStatistics calculateStatistics(
    const std::vector<HypothesisWithFeedback>& oldHypotheses,
    const std::unordered_map<db::TId, db::eye::Hypotheses>& newHypotheses);

using ObjectSelector = std::function<bool(const db::eye::Object&)>;

db::eye::Objects filterObjects(ObjectSelector, db::eye::Objects objects);

} // namespace maps::mrc:eye::qa
