#include "validator.h"

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/algorithm/parallel_for_each.h>
#include <maps/wikimap/mapspro/services/mrc/libs/object/include/loader.h>

namespace maps::mrc::eye::qa {

std::unordered_map<db::TId, db::eye::Hypotheses> validateInParallel(
    const ValidatorBase& validator,
    const ObjectsContext& objectsContext,
    LoaderByObjectIdFactory loaderFactory)
{
    std::unordered_map<db::TId, db::eye::Hypotheses> result;

    common::parallelForEach(objectsContext.begin(), objectsContext.end(),
        [&](auto& guard, const auto& context) {
            auto loader = loaderFactory(context.object.id());

            auto hypotheses =
                validator.validate(
                    context.object,
                    context.location,
                    context.slaveObjects,
                    *loader
                );

            if (!hypotheses.empty()) {
                const std::lock_guard<std::mutex> lock(guard);
                result.emplace(context.object.id(), hypotheses);
            }
        }
    );

    return result;
}

} // namespace maps::mrc::eye::qa
