#!/bin/sh
set -ex
# Create a hardlink to the graph file of the corresponding dataset

DATA_NAME="$(basename $ECSTATIC_DATA_PATH)"
SOURCE_DIR="/var/lib/yandex/maps/ecstatic/versions/${DATA_NAME}_${ECSTATIC_DATA_VERSION}"
TARGET_DIR="/var/spool/yandex/maps/graph/$ECSTATIC_DATA_VERSION"

# Check if the file exists in ecstatic
if [ ! -f "$SOURCE_DIR/$1" ]; then
    echo "Error: $SOURCE_DIR/$1 not exists or is not a regular file."
    exit 1
fi

mkdir -p "$TARGET_DIR"
ln -ft "$TARGET_DIR" "$SOURCE_DIR/$1"
echo "Created hardlink $TARGET_DIR/$1 to $SOURCE_DIR/$1."