#!/bin/sh
set -ex

GRAPH_VERSION="$ECSTATIC_DATA_VERSION"
TARGET_DIR="/var/spool/yandex/maps/graph/$GRAPH_VERSION"

# Check that this file is not used in the active graph
ACTIVE_GRAPH_VERSION=$(basename $(readlink /usr/share/yandex/maps/graph)) ||:
if [ "$GRAPH_VERSION" = "$ACTIVE_GRAPH_VERSION" ]; then
    if [ "$(readlink -m /usr/share/yandex/maps/graph/$1)" = "$TARGET_DIR/$1" ]; then
        echo "Error: Cannot remove hardlink $TARGET_DIR/$1 since it is used in /usr/share/yandex/maps/graph/$1."
        exit 1
    fi
fi

# Remove hardlink
rm -rf "$TARGET_DIR/$1"
rmdir --ignore-fail-on-non-empty "$TARGET_DIR"
echo "Hardlink $TARGET_DIR/$1 removed."