#include <maps/libs/config/include/config.h>
#include <maps/libs/vault_boy/include/secrets.h>
#include <maps/wikimap/mapspro/services/mrc/grinder-config/include/config.h>

namespace maps::mrc::grinder_config {

auto makeGrinderConfig(const cmdline::Option<std::string>& grinderConfigPath)
    -> grinder::Config
{
    if (grinderConfigPath.defined()) {
        return grinder::Config{grinderConfigPath};
    }
    else {
        auto keysPath = vault_boy::defaultPath("grinder");
        auto ctx = vault_boy::DirectoryContext{keysPath};
        return grinder::Config::fromString(
            ctx.renderTemplate(config::readConfigFile("grinder_config.json")));
    }
}

}  // namespace maps::mrc::grinder_config
