#include <maps/wikimap/mapspro/services/mrc/libs/birdview/include/birdview.h>

#include <maps/libs/common/include/exception.h>

#include <cmath>

namespace maps::mrc::birdview {
namespace {

std::vector<cv::Point2f> createViewArea(const cv::Point2f& vanishingPoint,
                                        int imageHeight)
{
    static const float TRAPEZOID_DEGREE = 75.;
    static const float TAN = std::tan(TRAPEZOID_DEGREE * CV_PI / 180.);
    static const float HORZ_SKIP_PART = 1. / 3.;

    std::vector<cv::Point2f> result(4);
    REQUIRE(imageHeight > vanishingPoint.y, "Invalid vanishing point");
    float height = imageHeight - vanishingPoint.y;

    result[0].x = vanishingPoint.x - TAN * height * HORZ_SKIP_PART;
    result[0].y = vanishingPoint.y + height * HORZ_SKIP_PART;

    result[1].x = vanishingPoint.x - TAN * height;
    result[1].y = imageHeight;

    result[2].x = vanishingPoint.x + TAN * height;
    result[2].y = imageHeight;

    result[3].x = vanishingPoint.x + TAN * height * HORZ_SKIP_PART;
    result[3].y = vanishingPoint.y + height * HORZ_SKIP_PART;

    return result;
}

std::vector<cv::Point2f> createRect(const cv::Size& imageSize)
{
    std::vector<cv::Point2f> result(4);

    result[0].x = 0;
    result[0].y = 0;

    result[1].x = 0;
    result[1].y = (float)imageSize.height;

    result[2].x = (float)imageSize.width;
    result[2].y = (float)imageSize.height;

    result[3].x = (float)imageSize.width;
    result[3].y = 0;

    return result;
}

} // anonymous namespace

cv::Mat findBirdviewTransformationMatrix(const cv::Point2f& vanishingPoint,
                                         int srcHeight,
                                         const cv::Size& destSize)
{
    cv::Mat result = cv::findHomography(
        createViewArea(vanishingPoint, srcHeight), createRect(destSize));
    result.convertTo(result, CV_32F);
    return result;
}

} // namespace maps::mrc::birdview
